/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.jameica.gui.AbstractItemXml;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.NavigationItem;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Enumeration;
import net.n3.nanoxml.IXMLElement;
import org.eclipse.swt.graphics.Image;

public class NavigationItemXml
extends AbstractItemXml
implements NavigationItem {
    public NavigationItemXml(NavigationItem parent, IXMLElement path, I18N i18n) {
        super(parent, path, i18n);
        Enumeration e = this.path.enumerateChildren();
        while (e.hasMoreElements()) {
            IXMLElement childPath = (IXMLElement)e.nextElement();
            this.childs.add(new NavigationItemXml(this, childPath, i18n));
        }
    }

    @Override
    public Image getIconOpen() {
        String s = this.path.getAttribute("icon-open", null);
        if (s == null || s.length() == 0) {
            s = this.path.getAttribute("icon-close", "empty.gif");
        }
        return SWTUtil.getImage(s);
    }

    @Override
    public Image getIconClose() {
        return SWTUtil.getImage(this.path.getAttribute("icon-close", "empty.gif"));
    }

    @Override
    public boolean isExpanded() throws RemoteException {
        String expanded = this.path.getAttribute("expanded", null);
        return expanded == null || expanded.equalsIgnoreCase("true");
    }

    @Override
    public void setEnabled(boolean enabled, boolean recursive) throws RemoteException {
        super.setEnabled(enabled, recursive);
        GUI.getNavigation().update(this);
        if (recursive) {
            for (int i = 0; i < this.childs.size(); ++i) {
                NavigationItem child = (NavigationItem)this.childs.get(i);
                child.setEnabled(enabled, recursive);
            }
        }
    }
}

